/**
 * @file pwm_ccu8.c
 * @date 2016-10-28
 *
 * NOTE:
 * This file is generated by DAVE. Any manual modification done to this file will be lost when the code is regenerated.
 *
 * @cond
 ***********************************************************************************************************************
 * PWM_CCU8 v4.1.26 - PWM APP using one timer slice of CCU8, with external events and dead time support,
 *                   to generate up to 4 PWM outputs.
 *
 * Copyright (c) 2015 - 2016, Infineon Technologies AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the
 * following conditions are met:
 *
 *   Redistributions of source code must retain the above copyright notice, this list of conditions and the  following
 *   disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote
 *   products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes
 * with Infineon Technologies AG (dave@infineon.com).
 ***********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-14:
 *     - Initial version for DAVEv4
 *
 * 2015-05-20:
 *     - PWM_CCU8_AcknowledgeInterrupt() api is renamed as PWM_CCU8_ClearEvent().
 *
 * 2015-06-20:
 *     - Copyright information updated.
 *
 * 2015-08-13:
 *     - Added support for selection of compare channel in external load event using API "XMC_CCU8_SLICE_LoadSelector"
 *     - Added support for selection of shadow transfer mode using API "XMC_CCU8_SLICE_SetShadowTransferMode"
 *     - Added support for selection of immediate shadow transfer using
 *       API "XMC_CCU8_SLICE_WriteImmediateAfterShadowTransfer" in XMC14* devices
 *     - Added support for automatic shadow transfer using
 *       API "XMC_CCU8_SLICE_EnableAutomaticShadowTransferRequest" in XMC14* devices
 *
 * 2016-03-21:
 *     - Bug Fix: Trap enable configuration is corrected in PWM_CCU8_lConfigure_Events() API.
 *
 * 2016-10-28:
 *     - Changed PWM_CCU8_Stop() to set the ST output to the passive value after stopping the timer.
 *
 * @endcond
 *
 */

/***********************************************************************************************************************
 * HEADER FILES
 **********************************************************************************************************************/
#include "pwm_ccu8.h"

/***********************************************************************************************************************
 * PRIVATE FUNCTION PROTOTYPES
 **********************************************************************************************************************/
/* Initialize the App Interrupts */
static void PWM_CCU8_lInit_Interrupt(PWM_CCU8_t* handle_ptr);

/* Initialize the App events and configurations */
static void PWM_CCU8_lConfigure_Events(PWM_CCU8_t* handle_ptr);

/* Initialize the App pin configurations */
static void PWM_CCU8_lInit_GPIO(PWM_CCU8_t* handle_ptr);

/***********************************************************************************************************************
 * MACROS
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * LOCAL DATA
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * LOCAL ROUTINES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * API IMPLEMENTATION
 **********************************************************************************************************************/

/* API to retrieve App version info */
DAVE_APP_VERSION_t PWM_CCU8_GetAppVersion(void)
{
  DAVE_APP_VERSION_t version;

  version.major = PWM_CCU8_MAJOR_VERSION;
  version.minor = PWM_CCU8_MINOR_VERSION;
  version.patch = PWM_CCU8_PATCH_VERSION;

  return version;
}

/* This function initializes the app */
PWM_CCU8_STATUS_t PWM_CCU8_Init(PWM_CCU8_t* handle_ptr)
{
  PWM_CCU8_STATUS_t status;
  GLOBAL_CCU8_STATUS_t status_ccu8_global;
  uint32_t frequency_module;
  uint32_t prescalar;

  status = PWM_CCU8_STATUS_FAILURE;
  status_ccu8_global = GLOBAL_CCU8_STATUS_FAILURE;
  XMC_ASSERT("PWM_CCU8_Init:handle_ptr is NULL", (handle_ptr != NULL));

  if (PWM_CCU8_STATE_UNINITIALIZED == handle_ptr->state)
  {
    /* Initialize consumed Apps */
    status_ccu8_global = GLOBAL_CCU8_Init(handle_ptr->config_ptr->global_ccu8_handle);

    /* Initialize CCU8x_CC8y slice */
    if (GLOBAL_CCU8_STATUS_SUCCESS == status_ccu8_global)
    {
      XMC_DEBUG("PWM_CCU8_Init:Initilizing slice");

      /* Configure CCU8x_CC8y slice as timer */
      XMC_CCU8_SLICE_CompareInit(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr);
      /* Set period match value of the timer  */
      XMC_CCU8_SLICE_SetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->period_value);

      /* Set timer compare match value for channel 1 */
      XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                          (uint16_t) handle_ptr->config_ptr->compare1_value);
      /* Set timer compare match value for channel 2 */
      XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                          (uint16_t) handle_ptr->config_ptr->compare2_value);

      if ((1U == handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->mcm_ch1_enable) || (1U
          == handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->mcm_ch2_enable))
      {
        XMC_CCU8_SetMultiChannelShadowTransferMode(handle_ptr->ccu8_module_ptr,
                                                   (uint32_t) handle_ptr->config_ptr->mcm_shadow_txfr_mode);
      }

#if (UC_SERIES != XMC45) /*STC register not available on XMC45xx devices */
      XMC_CCU8_SLICE_SetShadowTransferMode(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->shadow_transfer_mode);
#endif

#if (UC_SERIES == XMC14) /*below feature available in XMC14xx devices */
      XMC_CCU8_SLICE_WriteImmediateAfterShadowTransfer(handle_ptr->ccu8_slice_ptr,
                                                       handle_ptr->config_ptr->immediate_write);
      XMC_CCU8_SLICE_EnableAutomaticShadowTransferRequest(handle_ptr->ccu8_slice_ptr,
                                                          handle_ptr->config_ptr->automatic_shadow_transfer);
      if((bool)true == handle_ptr->config_ptr->cascaded_shadow_txfr_enable)
      {
        XMC_CCU8_SLICE_EnableCascadedShadowTransfer(handle_ptr->ccu8_slice_ptr);
      }
#endif

      /* Transfer value from shadow timer registers to actual timer registers */
      XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);
      XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->dither_shadow_txfr_msk);

      XMC_CCU8_SLICE_DeadTimeInit(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->dt_config_ptr);

      /* Configure events */
      PWM_CCU8_lConfigure_Events(handle_ptr);

      /* Enable the interrupts */
      PWM_CCU8_lInit_Interrupt(handle_ptr);

      /*Initializes the GPIO*/
      PWM_CCU8_lInit_GPIO(handle_ptr);

      frequency_module = handle_ptr->config_ptr->global_ccu8_handle->module_frequency;
      prescalar = (uint32_t) handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->prescaler_initval;
      frequency_module = frequency_module / ((uint32_t) 1 << prescalar);
      handle_ptr->frequency_tclk = frequency_module;

      handle_ptr->state = PWM_CCU8_STATE_INITIALIZED;
      status = PWM_CCU8_STATUS_SUCCESS;

      /* Start the PWM generation if start at initialization is enabled */
      if ((bool) true == handle_ptr->config_ptr->start_control)
      {
        status = PWM_CCU8_Start(handle_ptr);
      }

    }
    else
    {
      handle_ptr->state = PWM_CCU8_STATE_UNINITIALIZED;
    }

  }
  else
  {
    status = PWM_CCU8_STATUS_ALREADY_INITIALIZED;
    XMC_DEBUG("PWM_CCU8_Init:PWM_CCU8_STATUS_ALREADY_INITIALIZED");
  }

  return (status);
} /* end of PWM_CCU8_Init() api */

static void PWM_CCU8_lInit_Interrupt(PWM_CCU8_t* handle_ptr)
{

  /* Enable events. Bind event to corresponding service request node. */

  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_PERIOD_MATCH,
                                  handle_ptr->config_ptr->sr_per_match);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_UP_CH_1,
                                  handle_ptr->config_ptr->sr_cmp1_match_up);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_DOWN_CH_1,
                                  handle_ptr->config_ptr->sr_cmp1_match_down);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_UP_CH_2,
                                  handle_ptr->config_ptr->sr_cmp2_match_up);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_DOWN_CH_2,
                                  handle_ptr->config_ptr->sr_cmp2_match_down);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_ONE_MATCH,
                                  handle_ptr->config_ptr->sr_one_match_down);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_EVENT0,
                                  handle_ptr->config_ptr->sr_e0);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_EVENT1,
                                  handle_ptr->config_ptr->sr_e1);
  XMC_CCU8_SLICE_SetInterruptNode(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_EVENT2,
                                  handle_ptr->config_ptr->sr_e2);

  if ((bool) true == handle_ptr->config_ptr->int_per_match)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt period match enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_PERIOD_MATCH);
  }

  if ((bool) true == handle_ptr->config_ptr->int_cmp1_match_up)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt compare match ch1 up enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_UP_CH_1);
  }

  if ((bool) true == handle_ptr->config_ptr->int_cmp1_match_down)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt compare match ch1 down enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_DOWN_CH_1);
  }

  if ((bool) true == handle_ptr->config_ptr->int_cmp2_match_up)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt compare match ch2 up enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_UP_CH_2);
  }

  if ((bool) true == handle_ptr->config_ptr->int_cmp2_match_down)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt compare match ch2 down enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_COMPARE_MATCH_DOWN_CH_2);
  }

  if ((bool) true == handle_ptr->config_ptr->int_one_match_down)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt one match enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_ONE_MATCH);
  }

  if ((bool) true == handle_ptr->config_ptr->int_e0)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt event 0 enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_EVENT0);
  }

  if ((bool) true == handle_ptr->config_ptr->int_e1)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt event 1 enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_EVENT1);
  }

  if ((bool) true == handle_ptr->config_ptr->int_e2)
  {
    XMC_DEBUG("PWM_CCU8_Init: Interrupt event 2 enable");
    XMC_CCU8_SLICE_EnableEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_EVENT2);
  }
}
static void PWM_CCU8_lInit_GPIO(PWM_CCU8_t* handle_ptr)
{
  if ((bool) true == handle_ptr->config_ptr->gpio_ch1_out0_enable)
  {
    XMC_GPIO_Init(handle_ptr->config_ptr->gpio_ch1_out0_ptr, handle_ptr->config_ptr->gpio_ch1_out0_pin,
                  handle_ptr->config_ptr->gpio_ch1_out0_config_ptr);
  }

  if ((bool) true == handle_ptr->config_ptr->gpio_ch1_out1_enable)
  {
    XMC_GPIO_Init(handle_ptr->config_ptr->gpio_ch1_out1_ptr, handle_ptr->config_ptr->gpio_ch1_out1_pin,
                  handle_ptr->config_ptr->gpio_ch1_out1_config_ptr);
  }

  if ((bool) true == handle_ptr->config_ptr->gpio_ch2_out2_enable)
  {
    XMC_GPIO_Init(handle_ptr->config_ptr->gpio_ch2_out2_ptr, handle_ptr->config_ptr->gpio_ch2_out2_pin,
                  handle_ptr->config_ptr->gpio_ch2_out2_config_ptr);
  }

  if ((bool) true == handle_ptr->config_ptr->gpio_ch2_out3_enable)
  {
    XMC_GPIO_Init(handle_ptr->config_ptr->gpio_ch2_out3_ptr, handle_ptr->config_ptr->gpio_ch2_out3_pin,
                  handle_ptr->config_ptr->gpio_ch2_out3_config_ptr);
  }
}

static void PWM_CCU8_lConfigure_Events(PWM_CCU8_t* handle_ptr)
{
  /* Configure slice to a external event 0 */
  XMC_CCU8_SLICE_ConfigureEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_EVENT_0,
                                handle_ptr->config_ptr->event0_config_ptr);

  /* Configure slice to a external event 1 */
  XMC_CCU8_SLICE_ConfigureEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_EVENT_1,
                                handle_ptr->config_ptr->event1_config_ptr);

  /* Configure slice to a external event 2 */
  XMC_CCU8_SLICE_ConfigureEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_EVENT_2,
                                handle_ptr->config_ptr->event2_config_ptr);

  /* External signal controls start of the timer */
  if (XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_start_event)
  {
    XMC_CCU8_SLICE_StartConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_start_event,
                               handle_ptr->config_ptr->ext_start_mode);
  }

  /* External signal can stop the timer */
  if (XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_stop_event)
  {
    XMC_CCU8_SLICE_StopConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_stop_event,
                              handle_ptr->config_ptr->ext_stop_mode);
  }

  /* External signal can change the timer counting direction */
  if (XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_count_dir_event)
  {
    XMC_CCU8_SLICE_DirectionConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_count_dir_event);
  }
  /* External signal can stop the timer and the timer value remains same */
  if (XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_gate_event)
  {
    XMC_CCU8_SLICE_GateConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_gate_event);
  }
  /* Timer increments on external signal */
  if (XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_count_event)
  {
    XMC_CCU8_SLICE_CountConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_count_event);
  }
  /* Timer gets loaded with compare register value or period register value on external signal */
  if (XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_load_event)
  {
    XMC_CCU8_SLICE_LoadConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_load_event);
    XMC_CCU8_SLICE_LoadSelector(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_load_selector);
  }
  /* External signal PWM signal (ST bit) output gets modulated by external signal */
  if (XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_mod_event)
  {
    XMC_CCU8_SLICE_ModulationConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_mod_event,
                                    handle_ptr->config_ptr->ext_mod_mode, XMC_CCU8_SLICE_MODULATION_CHANNEL_1_AND_2,
                                    handle_ptr->config_ptr->ext_mod_sync);
  }

  /* PWM signal (ST bit) output gets modulated by external signal */
  if (XMC_CCU8_SLICE_EVENT_2 == handle_ptr->config_ptr->ext_trap_event)
  {
    XMC_CCU8_SLICE_TrapConfig(handle_ptr->ccu8_slice_ptr, handle_ptr->config_ptr->ext_trap_exit,
                              handle_ptr->config_ptr->ext_trap_sync);
    if ((bool) true == handle_ptr->config_ptr->ext_trap_enable)
    {
      XMC_CCU8_SLICE_EnableTrap(
          handle_ptr->ccu8_slice_ptr,
          (uint32_t)(XMC_CCU8_SLICE_OUTPUT_0 | XMC_CCU8_SLICE_OUTPUT_1 | XMC_CCU8_SLICE_OUTPUT_2 | XMC_CCU8_SLICE_OUTPUT_3)
		  );
    }
  }

  if ((XMC_CCU8_SLICE_EVENT_NONE != handle_ptr->config_ptr->ext_override_edge_event) || (XMC_CCU8_SLICE_EVENT_NONE
      != handle_ptr->config_ptr->ext_override_level_event))
  {
    XMC_CCU8_SLICE_ConfigureStatusBitOverrideEvent(handle_ptr->ccu8_slice_ptr,
                                                   handle_ptr->config_ptr->event1_config_ptr,
                                                   handle_ptr->config_ptr->event2_config_ptr);
    XMC_CCU8_SLICE_StatusBitOverrideConfig(handle_ptr->ccu8_slice_ptr);
  }

}
/**********************************************************************************************************/
/*Starts the CCU8_CC8 slice. This needs to be called even if external start is configured.*/
PWM_CCU8_STATUS_t PWM_CCU8_Start(PWM_CCU8_t* handle_ptr)
{
  PWM_CCU8_STATUS_t status;

  status = PWM_CCU8_STATUS_FAILURE;
  XMC_ASSERT("PWM_CCU8_Start:handle_ptr NULL", (handle_ptr != NULL));
  if ((PWM_CCU8_STATE_INITIALIZED == handle_ptr->state) || (PWM_CCU8_STATE_STOPPED == handle_ptr->state))
  {
    /* clear IDLE mode for the slice; Start timer */
    XMC_CCU8_EnableClock(handle_ptr->ccu8_module_ptr, handle_ptr->slice_number);

    if (XMC_CCU8_SLICE_EVENT_NONE == handle_ptr->config_ptr->ext_start_event)
    {
      XMC_CCU8_SLICE_StartTimer(handle_ptr->ccu8_slice_ptr);
    }

    handle_ptr->state = PWM_CCU8_STATE_RUNNING;
    status = PWM_CCU8_STATUS_SUCCESS;
    XMC_DEBUG("PWM_CCU8_Start:start PWM");
  }
  return (status);
} /* end of PWM_CCU8_Start() api */
/**********************************************************************************************************/
/*Stops the CCU8_CC8 slice. */
PWM_CCU8_STATUS_t PWM_CCU8_Stop(PWM_CCU8_t* handle_ptr)
{
  PWM_CCU8_STATUS_t status;

  status = PWM_CCU8_STATUS_FAILURE;
  XMC_ASSERT("PWM_CCU8_Stop:handle_ptr NULL", (handle_ptr != NULL));
  if (PWM_CCU8_STATE_UNINITIALIZED != handle_ptr->state)
  {
    XMC_CCU8_SLICE_StopTimer(handle_ptr->ccu8_slice_ptr);
    XMC_CCU8_SLICE_ClearTimer(handle_ptr->ccu8_slice_ptr);

    handle_ptr->state = PWM_CCU8_STATE_STOPPED;
    status = PWM_CCU8_STATUS_SUCCESS;
    XMC_DEBUG("PWM_CCU8_Stop:stop PWM");
  }
  return (status);

} /* end of PWM_CCU8_Stop() api */
/**********************************************************************************************************/
/*Gets the timer value of  CCU8_CC8 slice. */
uint32_t PWM_CCU8_GetTimerValue(PWM_CCU8_t* handle_ptr)
{
  uint32_t timer_value;
  XMC_ASSERT("PWM_CCU8_GetTimerValue:handle_ptr NULL", (handle_ptr != NULL));
  timer_value = (uint32_t) XMC_CCU8_SLICE_GetTimerValue(handle_ptr->ccu8_slice_ptr);
  XMC_DEBUG("PWM_CCU8_GetTimerValue:timer value");
  return (timer_value);
}/* end of PWM_CCU8_GetTimerValue() api */
/**********************************************************************************************************/
/*Gets the status of  CCU8_CC8 slice. */
bool PWM_CCU8_GetTimerStatus(PWM_CCU8_t* handle_ptr)
{
  bool status_timer;
  XMC_ASSERT("PWM_CCU8_GetTimerStatus:handle_ptr NULL", (handle_ptr != NULL));
  status_timer = XMC_CCU8_SLICE_IsTimerRunning(handle_ptr->ccu8_slice_ptr);
  return (status_timer);

} /* end of PWM_CCU8_GetStatus() api */
/**********************************************************************************************************/

/*Sets the frequency for CCU8_CC8 slice Symmetric Mode. */
PWM_CCU8_STATUS_t PWM_CCU8_SetFreqSymmetric(PWM_CCU8_t* handle_ptr, uint32_t pwm_freq_hz)
{
  PWM_CCU8_STATUS_t status;
  uint32_t frequency_tclk;
  uint32_t period;
  uint32_t duty_ch1;
  uint32_t duty_ch2;
  uint16_t compare_ch1;
  uint16_t compare_ch2;

  status = PWM_CCU8_STATUS_FAILURE;
  frequency_tclk = 0U;
  XMC_ASSERT("PWM_CCU8_SetFreqSymmetric:handle_ptr NULL", (handle_ptr != NULL));
  if (PWM_CCU8_STATE_UNINITIALIZED != handle_ptr->state)
  {
    if (0U == pwm_freq_hz)
    {
      XMC_DEBUG("PWM_CCU8_SetPwmFreq:cannot set frequency 0Hz");
    }
    else
    {
      frequency_tclk = handle_ptr->frequency_tclk;
      period = frequency_tclk / pwm_freq_hz;

      if ((uint32_t) XMC_CCU8_SLICE_TIMER_COUNT_MODE_CA == handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->timer_mode)
      {
        period = period >> 1U;/*divide by 2*/
      }

      if ((period != 0U) && (period <= PWM_CCU8_MAX_TIMER_COUNT))
      {
        /*Calculate the current duty cycle in no-timer concatenation mode*/
        duty_ch1 = handle_ptr->sym_duty1;
        duty_ch2 = handle_ptr->sym_duty2;

        duty_ch1 = (PWM_CCU8_DUTY_FULL_SCALE - duty_ch1);
        duty_ch1 = duty_ch1 * period;
        duty_ch1 = duty_ch1 / PWM_CCU8_DUTY_FULL_SCALE;

        duty_ch2 = (PWM_CCU8_DUTY_FULL_SCALE - duty_ch2);
        duty_ch2 = duty_ch2 * period;
        duty_ch2 = duty_ch2 / PWM_CCU8_DUTY_FULL_SCALE;

        compare_ch1 = (uint16_t) duty_ch1;
        compare_ch2 = (uint16_t) duty_ch2;

        XMC_CCU8_SLICE_SetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr, (uint16_t)(period - 1U));
        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1, compare_ch1);
        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2, compare_ch2);
        XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);
        XMC_DEBUG("PWM_CCU8_SetPwmFreq:frequency set");
        status = PWM_CCU8_STATUS_SUCCESS;
      }
    }
  }
  return (status);

} /* end of PWM_CCU8_SetFreqSymmetric() api */

/**********************************************************************************************************/

/*Sets the duty cycle (uint32_t) for CCU8_CC8 slice. */
PWM_CCU8_STATUS_t PWM_CCU8_SetDutyCycleSymmetric(PWM_CCU8_t* handle_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_t channel,
                                                 uint32_t duty_cycle)
{
  PWM_CCU8_STATUS_t status;
  uint32_t period;
  uint32_t compare;

  status = PWM_CCU8_STATUS_FAILURE;
  XMC_ASSERT("PWM_CCU8_SetDutyCycleSymmetric:handle_ptr NULL", (handle_ptr != NULL));
  if (PWM_CCU8_STATE_UNINITIALIZED != handle_ptr->state)
  {
    /* duty cycle has to be in between 0 and 100 */
    if ((duty_cycle > PWM_CCU8_SYM_DUTY_MAX))
    {
      XMC_DEBUG("PWM_CCU8_SetDutyCycleSymmetric:Cannot set duty cycle > 100%");
    }
    else
    {
      period = (uint32_t) XMC_CCU8_SLICE_GetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr) + 1U;

      /* Duty Cycle(symmetric) = ((PR + 1)- CR) / (PR + 1) */
      compare = ((period * (PWM_CCU8_DUTY_FULL_SCALE - duty_cycle)) / PWM_CCU8_DUTY_FULL_SCALE);

      XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, channel, (uint16_t) compare);
      XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);

      if (XMC_CCU8_SLICE_COMPARE_CHANNEL_1 == channel)
      {
        handle_ptr->sym_duty1 = duty_cycle;
      }
      else
      {
        handle_ptr->sym_duty2 = duty_cycle;
      }

      XMC_DEBUG("PWM_CCU8_SetDutyCycleSymmetric:dutycycle set");
      status = PWM_CCU8_STATUS_SUCCESS;
    }
  }
  return (status);
} /* end of PWM_CCU8_SetDutyCycleSymmetric() api */

/**********************************************************************************************************/

/*Sets the frequency and duty cycle for CCU8_CC8 slice Symmetric Mode. */
PWM_CCU8_STATUS_t PWM_CCU8_SetFreqAndDutyCycleSymmetric(PWM_CCU8_t* handle_ptr, uint32_t pwm_freq_hz, uint32_t duty_ch1,
                                                        uint32_t duty_ch2)
{

  PWM_CCU8_STATUS_t status;
  uint32_t frequency_tclk;
  uint32_t period;
  uint32_t compare_ch1;
  uint32_t compare_ch2;

  status = PWM_CCU8_STATUS_FAILURE;
  frequency_tclk = 0U;
  XMC_ASSERT("PWM_CCU8_SetFreqAndDutyCycleSymmetric:handle_ptr NULL", (handle_ptr != NULL));
  if (PWM_CCU8_STATE_UNINITIALIZED != handle_ptr->state)
  {
    if (0U == pwm_freq_hz)
    {
      XMC_DEBUG("PWM_CCU8_SetFreqAndDutyCycleSymmetric:cannot set frequency 0Hz");
    }
    else if ((duty_ch1 > PWM_CCU8_SYM_DUTY_MAX) || (duty_ch2 > PWM_CCU8_SYM_DUTY_MAX))
    {
      XMC_DEBUG("PWM_CCU8_SetFreqAndDutyCycleSymmetric:duty > 100%");
    }
    else
    {
      frequency_tclk = handle_ptr->frequency_tclk;
      period = frequency_tclk / pwm_freq_hz;

      if ((uint32_t) XMC_CCU8_SLICE_TIMER_COUNT_MODE_CA == handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->timer_mode)
      {
        period = period >> 1U;/*divide by 2*/
      }

      if ((period != 0U) && (period <= PWM_CCU8_MAX_TIMER_COUNT))
      {
        /*Calculate the current duty cycle in no-timer concatenation mode*/
        compare_ch1 = ((period * (PWM_CCU8_DUTY_FULL_SCALE - duty_ch1)) / PWM_CCU8_DUTY_FULL_SCALE);
        compare_ch2 = ((period * (PWM_CCU8_DUTY_FULL_SCALE - duty_ch2)) / PWM_CCU8_DUTY_FULL_SCALE);

        XMC_CCU8_SLICE_SetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr, (uint16_t)(period - 1U));
        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                            (uint16_t) compare_ch1);
        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                            (uint16_t) compare_ch2);
        XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);

        handle_ptr->sym_duty1 = duty_ch1;
        handle_ptr->sym_duty2 = duty_ch2;

        XMC_DEBUG("PWM_CCU8_SetFreqAndDutyCycleSymmetric:frequency set");
        status = PWM_CCU8_STATUS_SUCCESS;
      }
    }
  }
  return (status);

}/* end of PWM_CCU8_SetFreqAndDutyCycleSymmetric() api */

/**********************************************************************************************************/

/*Sets the frequency for CCU8_CC8 slice Asymmetric Mode. */
PWM_CCU8_STATUS_t PWM_CCU8_SetFreqAsymmetric(PWM_CCU8_t* handle_ptr, uint32_t pwm_freq_hz)
{
  PWM_CCU8_STATUS_t status;
  uint32_t frequency_tclk;
  uint32_t period;
  uint32_t duty_cycle;
  uint32_t shift;
  uint32_t compare_ch1;
  uint32_t compare_ch2;

  status = PWM_CCU8_STATUS_FAILURE;
  frequency_tclk = 0U;
  XMC_ASSERT("PWM_CCU8_SetFreqAsymmetric:handle_ptr NULL", (handle_ptr != NULL));
  if (PWM_CCU8_STATE_UNINITIALIZED != handle_ptr->state)
  {
    if (0U == pwm_freq_hz)
    {
      XMC_DEBUG("PWM_CCU8_SetPwmFreq:cannot set frequency 0Hz");
    }
    else
    {
      frequency_tclk = handle_ptr->frequency_tclk;
      period = frequency_tclk / pwm_freq_hz;

      duty_cycle = handle_ptr->asym_duty;
      shift = handle_ptr->asym_shift;

      if ((uint32_t) XMC_CCU8_SLICE_TIMER_COUNT_MODE_CA == handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->timer_mode)
      {
        period = period >> 1U;/*divide by 2*/

        if ((period != 0U) && (period <= PWM_CCU8_MAX_TIMER_COUNT))
        {
          compare_ch1 = (2U * period * shift);
          compare_ch1 = compare_ch1 / PWM_CCU8_DUTY_FULL_SCALE;
          compare_ch2 = (2U * period * (PWM_CCU8_DUTY_FULL_SCALE - (shift + duty_cycle)));
          compare_ch2 = compare_ch2 / PWM_CCU8_DUTY_FULL_SCALE;

          XMC_CCU8_SLICE_SetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr, (uint16_t)(period - 1U));
          XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                              (uint16_t) compare_ch1);
          XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                              (uint16_t) compare_ch2);
          XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);
          XMC_DEBUG("PWM_CCU8_SetPwmFreq:frequency set center aligned mode");
          status = PWM_CCU8_STATUS_SUCCESS;
        }
      }
      else
      {
        if (period <= PWM_CCU8_MAX_TIMER_COUNT)
        {
          compare_ch1 = period * shift;
          compare_ch1 = compare_ch1 / PWM_CCU8_DUTY_FULL_SCALE;
          compare_ch2 = period * (shift + duty_cycle);
          compare_ch2 = compare_ch2 / PWM_CCU8_DUTY_FULL_SCALE;

          XMC_CCU8_SLICE_SetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr, (uint16_t)(period - 1U));
          XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                              (uint16_t) compare_ch1);
          XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                              (uint16_t) compare_ch2);
          XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);
          XMC_DEBUG("PWM_CCU8_SetPwmFreq:frequency set edge aligned mode");
          status = PWM_CCU8_STATUS_SUCCESS;
        }
      }
    }
  }
  return (status);
}/* end of PWM_CCU8_SetFreqAsymmetric() api */

/**********************************************************************************************************/

/*Sets the duty cycle and shift (uint32_t) for CCU8_CC8 slice in Asymmetric mode. */
/*(shift + duty_cycle <= 100)  and (shift + duty_cycle >= 50) */
PWM_CCU8_STATUS_t PWM_CCU8_SetDutyCycleAsymmetric(PWM_CCU8_t* handle_ptr, uint32_t shift, uint32_t duty_cycle)
{
  PWM_CCU8_STATUS_t status;
  uint32_t period;
  uint32_t compare_ch1;
  uint32_t compare_ch2;

  status = PWM_CCU8_STATUS_FAILURE;
  XMC_ASSERT("PWM_CCU8_SetDutyCycleAsymmetric:handle_ptr NULL", (handle_ptr != NULL));
  if (PWM_CCU8_STATE_UNINITIALIZED != handle_ptr->state)
  {
    if ((uint32_t) XMC_CCU8_SLICE_TIMER_COUNT_MODE_CA == handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->timer_mode)
    {
      /*center aligned mode*/
      if (((shift + duty_cycle) > PWM_CCU8_ASYM_CA_MAX) || ((shift + duty_cycle) < PWM_CCU8_ASYM_CA_MIN))
      {
        XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:Cannot set center aligned mode 50% < (shift + duty_cycle) < 100%");
      }
      else if (shift >= PWM_CCU8_ASYM_CA_SHIFT_MAX)
      {
        XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:Cannot set center aligned mode shift > 50%");
      }
      else
      {
        period = (uint32_t) XMC_CCU8_SLICE_GetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr);

        compare_ch1 = ((2U * period * shift) / PWM_CCU8_DUTY_FULL_SCALE);
        compare_ch2 = ((2U * period * (PWM_CCU8_DUTY_FULL_SCALE - (shift + duty_cycle))) / PWM_CCU8_DUTY_FULL_SCALE);

        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                            (uint16_t) compare_ch1);
        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                            (uint16_t) compare_ch2);
        XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);

        handle_ptr->asym_duty = duty_cycle;
        handle_ptr->asym_shift = shift;

        XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:dutycycle set center aligned mode");
        status = PWM_CCU8_STATUS_SUCCESS;
      }

    }
    else
    {
      /*edge aligned mode*/
      if (((shift + duty_cycle) > PWM_CCU8_ASYM_EA_MAX))
      {
        XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:Cannot set edge aligned mode (shift + duty_cycle) > 100%");
      }
      else
      {
        period = (uint32_t) XMC_CCU8_SLICE_GetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr);

        compare_ch1 = ((period * shift) / PWM_CCU8_DUTY_FULL_SCALE);
        compare_ch2 = ((period * (shift + duty_cycle)) / PWM_CCU8_DUTY_FULL_SCALE);

        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                            (uint16_t) compare_ch1);
        XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                            (uint16_t) compare_ch2);
        XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);

        handle_ptr->asym_duty = duty_cycle;
        handle_ptr->asym_shift = shift;

        XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:dutycycle set edge aligned mode");
        status = PWM_CCU8_STATUS_SUCCESS;
      }
    }
  }
  return (status);
}/* end of PWM_CCU8_SetDutyCycleAsymmetric() api */

/**********************************************************************************************************/

/*Sets the frequency, (uint32_t)shift and (uint32_t)duty cycle for CCU8_CC8 slice Asymmetric Mode. */
PWM_CCU8_STATUS_t PWM_CCU8_SetFreqAndDutyCycleAsymmetric(PWM_CCU8_t* handle_ptr, uint32_t pwm_freq_hz, uint32_t shift,
                                                         uint32_t duty_cycle)
{
  PWM_CCU8_STATUS_t status;
  uint32_t frequency_tclk;
  uint32_t period;
  uint32_t compare_ch1;
  uint32_t compare_ch2;

  status = PWM_CCU8_STATUS_FAILURE;
  frequency_tclk = 0U;
  XMC_ASSERT("PWM_CCU8_SetFreqAndDutyCycleAsymmetric:handle_ptr NULL", (handle_ptr != NULL));
  if (PWM_CCU8_STATE_UNINITIALIZED != handle_ptr->state)
  {
    if (0U == pwm_freq_hz)
    {
      XMC_DEBUG("PWM_CCU8_SetFreqAndDutyCycleAsymmetric:cannot set frequency 0Hz");
    }
    else
    {
      frequency_tclk = handle_ptr->frequency_tclk;
      period = frequency_tclk / pwm_freq_hz;

      if ((uint32_t) XMC_CCU8_SLICE_TIMER_COUNT_MODE_CA == handle_ptr->config_ptr->ccu8_cc8_slice_timer_ptr->timer_mode)
      {
        if (((shift + duty_cycle) > PWM_CCU8_ASYM_CA_MAX) || ((shift + duty_cycle) < PWM_CCU8_ASYM_CA_MIN))
        {
          XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:Cannot set center aligned mode 50% < (shift + duty_cycle) < 100%");
        }
        else if (shift >= PWM_CCU8_ASYM_CA_SHIFT_MAX)
        {
          XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:Cannot set center aligned mode shift > 50%");
        }
        else
        {
          period = period >> 1U;/*divide by 2*/

          if ((period != 0U) && (period <= PWM_CCU8_MAX_TIMER_COUNT))
          {
            compare_ch1 = ((2U * period * shift) / PWM_CCU8_DUTY_FULL_SCALE);
            compare_ch2 =
                ((2U * period * (PWM_CCU8_DUTY_FULL_SCALE - (shift + duty_cycle))) / PWM_CCU8_DUTY_FULL_SCALE);

            XMC_CCU8_SLICE_SetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr, (uint16_t)(period - 1U));
            XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                                (uint16_t) compare_ch1);
            XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                                (uint16_t) compare_ch2);
            XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);

            handle_ptr->asym_duty = duty_cycle;
            handle_ptr->asym_shift = shift;

            XMC_DEBUG("PWM_CCU8_SetFreqAndDutyCycleAsymmetric:frequency and duty set center aligned mode");
            status = PWM_CCU8_STATUS_SUCCESS;
          }
        }
      }
      else
      {
        if (period <= PWM_CCU8_MAX_TIMER_COUNT)
        {
          if (((shift + duty_cycle) > PWM_CCU8_ASYM_EA_MAX))
          {
            XMC_DEBUG("PWM_CCU8_SetDutyCycleAsymmetric:Cannot set edge aligned mode (shift + duty_cycle) > 100%");
          }
          else
          {
            compare_ch1 = ((period * shift) / PWM_CCU8_DUTY_FULL_SCALE);
            compare_ch2 = ((period * (shift + duty_cycle)) / PWM_CCU8_DUTY_FULL_SCALE);

            XMC_CCU8_SLICE_SetTimerPeriodMatch(handle_ptr->ccu8_slice_ptr, (uint16_t)(period - 1U));
            XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_1,
                                                (uint16_t) compare_ch1);
            XMC_CCU8_SLICE_SetTimerCompareMatch(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_2,
                                                (uint16_t) compare_ch2);
            XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->shadow_txfr_msk);

            handle_ptr->asym_duty = duty_cycle;
            handle_ptr->asym_shift = shift;

            XMC_DEBUG("PWM_CCU8_SetFreqAndDutyCycleAsymmetric:frequency and duty set edge aligned mode");
            status = PWM_CCU8_STATUS_SUCCESS;
          }

        }
      }
    }
  }
  return (status);
}/* end of PWM_CCU8_SetFreqAndDutyCycleAsymmetric() api */

/**********************************************************************************************************/

/*Sets the dither value, enables the dither. */
void PWM_CCU8_SetDither(PWM_CCU8_t* handle_ptr, bool dither_period, bool dither_comp, uint8_t dither_value)
{

  XMC_ASSERT("PWM_CCU8_SetDither:handle_ptr NULL", (handle_ptr != NULL));
  XMC_CCU8_SLICE_EnableDithering(handle_ptr->ccu8_slice_ptr, dither_period, dither_comp, dither_value);
  XMC_CCU8_EnableShadowTransfer(handle_ptr->ccu8_module_ptr, handle_ptr->dither_shadow_txfr_msk);
  XMC_DEBUG("PWM_CCU8_SetDither:dither compare value set");

}/* end of PWM_CCU8_SetDither() api */

/*exits trap condition if trap signal is inactive */
void PWM_CCU8_ClearTrap(PWM_CCU8_t* handle_ptr)
{

  XMC_ASSERT("PWM_CCU8_ClearTrap:handle_ptr NULL", (handle_ptr != NULL));
  XMC_CCU8_SLICE_ClearEvent(handle_ptr->ccu8_slice_ptr, XMC_CCU8_SLICE_IRQ_ID_EVENT2);
  XMC_DEBUG("PWM_CCU8_ClearTrap:trap event cleared");

}/* end of PWM_CCU8_ClearTrap() api */

/*Sets the dead time*/
void PWM_CCU8_SetDeadTime(PWM_CCU8_t* handle_ptr, XMC_CCU8_SLICE_COMPARE_CHANNEL_t channel, uint8_t rise_value,
                          uint8_t fall_value)
{
  XMC_ASSERT("PWM_CCU8_SetDeadTime:handle_ptr NULL", (handle_ptr != NULL));
  XMC_CCU8_SLICE_SetDeadTimeValue(handle_ptr->ccu8_slice_ptr, channel, rise_value, fall_value);
  XMC_DEBUG("PWM_CCU8_SetDeadTime:dead time set");
}/* end of PWM_CCU8_SetDeadTime() api */

/*Gets the interrupt status of  CCU8_CC8 slice. */
bool PWM_CCU8_GetInterruptStatus(PWM_CCU8_t* handle_ptr, XMC_CCU8_SLICE_IRQ_ID_t pwm_interrupt)
{
  bool status = (bool) false;
  XMC_ASSERT("PWM_CCU8_GetInterruptStatus:handle_ptr NULL", (handle_ptr != NULL));
  status = XMC_CCU8_SLICE_GetEvent(handle_ptr->ccu8_slice_ptr, pwm_interrupt);
  return (status);
} /* end of PWM_CCU8_GetInterruptStatus() api */

/*Acknowledges the interrupt of  CCU8_CC8 slice. */
void PWM_CCU8_ClearEvent(PWM_CCU8_t* handle_ptr, XMC_CCU8_SLICE_IRQ_ID_t pwm_interrupt)
{
  XMC_ASSERT("PWM_CCU8_ClearEvent:handle_ptr NULL", (handle_ptr != NULL));
  XMC_CCU8_SLICE_ClearEvent(handle_ptr->ccu8_slice_ptr, pwm_interrupt);
  XMC_DEBUG("PWM_CCU8_ClearEvent:Acknowledge Interrupt");
} /* end of PWM_CCU8_ClearEvent() api */

/* end of CCU8 function definitions */

